from datetime import datetime

# we're constructing data structure (either list or dict) with data to be given to string format,
# but we don't want strings on some level to be printed with quotes
# this wraps a string, but when called str or repr upon, it returns unquoted representation
class PrintableString:
  def __init__(self, string):
    self.string = string

  def __str__(self):
    return self.string

  def __repr__(self):
    return self.string

def preprocess(obj):
  if isinstance(obj, datetime):
    return PrintableString('<datetime %s>' % obj)
  return obj

def custom_repr(obj):
  preprocessed = { PrintableString(str(key)): preprocess(val) for key, val in obj.__dict__.items() }

  return "<%s %s>" % (obj.__class__.__name__, str(preprocessed)[1:-1])

class Printable:
  __str__  = custom_repr
  __repr__ = custom_repr
