def tail(filename, lines=20):
  """
  Returns the last `lines` lines of ASCII file `filename` as a list.
  """
  if lines == 0: return []

  with open(filename, 'rb') as file:
    file.seek(0, 2)

    block_size = 1024
    bytes = file.tell()
    size  = lines + 1
    block = -1
    data  = []

    while size > 0 and bytes > 0:
      if bytes - block_size > 0:
        # Seek back one whole block_size
        file.seek(block * block_size, 2)
        # read block
        data.insert(0, file.read(block_size))
      else:
        # file too small, start from begining
        file.seek(0,0)
        # only read what was not read
        data.insert(0, file.read(bytes))

      size  -= data[0].count(b'\n')
      bytes -= block_size
      block -= 1

  return str(b'\n'.join(b''.join(data).splitlines()[-lines:]), 'ascii')
