from contextlib import contextmanager
from inspect import isclass

@contextmanager
def error_translation(old_error, new_error):
  try:
    yield
  except old_error as e:
    if isclass(new_error):
      raise new_error(e)
    else:
      raise new_error
