import dateutil.parser, dateutil.tz

# in python 3.6+, the .replace(tzinfo = dateutil.tz.tzlocal()) calls are unnecessary
# since .astimezone() uses local tz by default

def local_to_aware(datetime):
  return datetime.replace(tzinfo = dateutil.tz.tzlocal()).astimezone()

def parse_to_aware(dt_string):
  datetime = dateutil.parser.parse(dt_string)

  if not datetime.tzinfo: datetime = datetime.replace(tzinfo = dateutil.tz.tzlocal())

  return datetime.astimezone()
