import uuid
from alto_django_utils.viewsets      import viewset_for
from alto_django_utils.permissions   import CustomObjectPermissions
from alto_django_canteen.utils import get_client_ip
from alto_django_canteen.models      import Canteen, Terminal, Meal, Order, Course, CourseGroup
from alto_django_canteen.serializers import (
  CanteenSerializer, MealSerializer, OrderSerializer,
  CourseSerializer, CourseGroupSerializer, TerminalSerializer)

MealViewSet         = viewset_for(Meal,        MealSerializer)
OrderViewSet        = viewset_for(Order,       OrderSerializer)
CourseViewSet       = viewset_for(Course,      CourseSerializer)
CanteenViewSet      = viewset_for(Canteen,     CanteenSerializer)
CourseGroupViewSet  = viewset_for(CourseGroup, CourseGroupSerializer)
BaseTerminalViewSet = viewset_for(Terminal,    TerminalSerializer)

MealViewSet.permission_classes    = [CustomObjectPermissions]
CanteenViewSet.permission_classes = [CustomObjectPermissions]

class TerminalViewSet(BaseTerminalViewSet):
  def create(self, request, *args, **kwargs):
    request.data['ip']     = request.data.get('ip', get_client_ip(request))
    request.data['secret'] = request.data.get('secret', str(uuid.uuid4()))

    return super().create(request, *args, **kwargs)

  def update(self, request, *args, **kwargs):
    instance = self.get_object()

    # overwrite ip only if explicitly provided, never autofill
    request.data['ip'] = request.data.get('ip', instance.ip)
    # set secret if explicitly provided or not yet set
    request.data['secret'] = request.data.get('secret', instance.secret or str(uuid.uuid4()))

    return super().update(request, *args, **kwargs)
