import pytest
from alto_django_utils.tests.fixtures     import api_client
from alto_django_base_auth.tests.fixtures import (
  auth_helpers,
  user_defaults,
  username_credentials_factory,
  user_credentials,
  user_factory,
  admin_token
)
from alto_django_kredit.tests.fixtures import client_factory
from alto_django_canteen.models        import Terminal
from .helpers                          import CanteenHelpers
from .factories                        import CardNumberFactory

@pytest.fixture
def canteen_helpers(auth_helpers, api_client):
  return CanteenHelpers(auth_helpers, api_client)

@pytest.fixture
def terminal_factory(canteen_helpers, admin_token):
  def f(name, secret = None):
    canteen_helpers.register_terminal(name = name, token = admin_token, secret = secret)

    return Terminal.objects.get(name = name)

  return f

@pytest.fixture
def card_number_factory():
  return CardNumberFactory

@pytest.fixture
def terminal_user_credentials(card_number_factory):
  return card_number_factory()

@pytest.fixture
def terminal_client(client_factory, terminal_user_credentials):
  return client_factory(chip_id = terminal_user_credentials['card_number'],
                        firstname = 'Terminal', surname = 'User')

@pytest.fixture
def terminal_user(user_factory, terminal_client):
  return user_factory(username = 'terminal_user',
                      client = terminal_client, email = terminal_client.email,
                      first_name = terminal_client.firstname, last_name = terminal_client.surname)

@pytest.fixture
def terminal(terminal_factory):
  return terminal_factory(name = 'test terminal')
