from django.contrib.auth import get_user_model
from rest_framework.test import APITestCase
from alto_django_client_auth.tests.helpers import ClientAuthHelpers
from alto_django_canteen.tests.helpers import CanteenHelpers

User       = get_user_model()
uuid_regex = '[a-f0-9]{8}-?[a-f0-9]{4}-?4[a-f0-9]{3}-?[89ab][a-f0-9]{3}-?[a-f0-9]{12}'

class IsRegisteredTerminalTests(APITestCase, ClientAuthHelpers, CanteenHelpers):
  def setUp(self):
    self.admin       = User.objects.create_superuser('admin', 'admin@test.cz', 'admin')
    self.admin_token = self.get_token(username = 'admin',  password = 'admin' ).data['token']

  def test_success(self):
    register_response = self.register_terminal(name = 'test', token = self.admin_token)
    secret            = register_response.data['terminal']['secret']

    response = self.is_registered_terminal(secret)

    assert response.status_code == 200
    assert response.data['is_registered']
    assert response.data['terminal']['name'] == 'test'

  def test_terminal_not_registered(self):
    response = self.is_registered_terminal()

    assert response.status_code == 200
    assert not response.data['terminal']
    assert not response.data['is_registered']

  def test_terminal_bad_secret(self):
    self.register_terminal(name = 'test', token = self.admin_token)

    response = self.is_registered_terminal('bad secret')

    assert response.status_code == 200
    assert not response.data['terminal']
    assert not response.data['is_registered']
