from datetime import date, timedelta
from django.contrib.auth import get_user_model
from rest_framework.test import APITestCase
from alto_django_client_auth.tests.helpers import ClientAuthHelpers
from alto_django_kredit.models import Client
from alto_django_canteen.models import Canteen, CourseGroup, Order
from alto_django_canteen.tests.helpers import CanteenHelpers
from alto_django_canteen.tests.factories import MealFactory, CourseFactory

User     = get_user_model()
today    = date.today()
tomorrow = date.today() + timedelta(days = 1)

class MealOrderingTests(APITestCase, ClientAuthHelpers, CanteenHelpers):
  def setUp(self):
    self.client_    = Client.objects.create(client_id = '123', card_id = '123',
                                            email = 'client@test.cz')
    self.user       = User.objects.create_user('test', 'test@test.cz', 'test',
                                               client = self.client_)
    self.user_token = self.get_token(username = 'test',  password = 'test' ).data['token']

    self.canteen = Canteen.objects.create(name = 'canteen')
    self.lunch   = CourseGroup.objects.get(name = 'lunch')
    self.soup    = CourseFactory.create(name = 'soup',   group = self.lunch)
    self.main    = CourseFactory.create(name = 'main',   group = self.lunch)
    self.desert  = CourseFactory.create(name = 'desert', group = self.lunch)

    MealFactory.create(date = today,    canteen = self.canteen, course = self.soup)
    MealFactory.create(date = today,    canteen = self.canteen, course = self.main)
    MealFactory.create(date = today,    canteen = self.canteen, course = self.desert)

    MealFactory.create(date = tomorrow, canteen = self.canteen, course = self.soup)
    MealFactory.create(date = tomorrow, canteen = self.canteen, course = self.main)
    MealFactory.create(date = tomorrow, canteen = self.canteen, course = self.desert)

  def test_creates_orders(self):
    orders = [
      {'course': 'soup',   'number': 1},
      {'course': 'main',   'number': 1},
      {'course': 'desert', 'number': 1},
    ]

    self.order_course_group(today,    self.canteen, self.lunch, orders, self.user_token)
    self.order_course_group(tomorrow, self.canteen, self.lunch, orders, self.user_token)

    assert Order.objects.count() == 6

    response = self.cancel_course_group(today, self.canteen, self.lunch, self.user_token)

    assert response.status_code  == 200
    assert Order.objects.count() == 3
