# Generated by Django 2.0.4 on 2018-07-05 14:06

import datetime
from django.db.models import (CharField, TimeField, DurationField, PositiveSmallIntegerField,
                              ForeignKey, F, Min)
from django.db.migrations import Migration, CreateModel, AlterField, RemoveField, RunPython
from alto_django_utils.models import PROTECT

def create_course_groups(apps, schema_editor):
  Course      = apps.get_model('alto_django_canteen', 'Course')
  CourseGroup = apps.get_model('alto_django_canteen', 'CourseGroup')

  groups = Course.objects.values('group') \
    .annotate(name = F('group'), order_number = Min('order_number'),
              served_at = Min('served_at'), lock_before = Min('lock_before'))

  for group in groups:
    CourseGroup.objects.create(name         = group['name'],
                               display_name = group['name'],
                               order_number = group['order_number'],
                               served_at    = group['served_at'],
                               lock_before  = group['lock_before'])

class Migration(Migration):
    dependencies = [
        ('alto_django_canteen', '0011_add_verbose_names'),
    ]

    operations = [
        CreateModel(
            name='CourseGroup',
            fields=[
                ('name', CharField(max_length=16, primary_key=True, serialize=False)),
                ('display_name', CharField(max_length=64)),
                ('served_at', TimeField()),
                ('lock_before', DurationField(default=datetime.timedelta)),
                ('order_number', PositiveSmallIntegerField(unique=True)),
            ],
            options={
                'verbose_name': 'skupina chodů',
                'verbose_name_plural': 'skupiny chodů',
                'db_table': 'course_groups',
            },
        ),

        RunPython(create_course_groups, RunPython.noop),

        RemoveField(
            model_name='course',
            name='lock_before',
        ),

        RemoveField(
            model_name='course',
            name='served_at',
        ),

        AlterField(
            model_name='course',
            name='group',
            field=ForeignKey(on_delete=PROTECT, related_name='courses', to='alto_django_canteen.CourseGroup', verbose_name='skupina'),
        ),
    ]
