# Generated by Django 2.0.4 on 2018-06-25 19:12

from django.db import migrations, models

def up(apps, schema_editor):
    Meal   = apps.get_model('alto_django_canteen', 'Meal')
    Course = apps.get_model('alto_django_canteen', 'Course')

    Meal.objects.update(stock_card_number = models.F('id'))
    Course.objects.update(group = models.F('name'))

class Migration(migrations.Migration):
    dependencies = [
        ('alto_django_canteen', '0006_create_canteens'),
    ]

    operations = [
        migrations.AddField(
            model_name='meal',
            name='stock_card_number',
            field=models.PositiveIntegerField(blank = True, null = True),
        ),

        migrations.AddField(
            model_name='course',
            name='group',
            field=models.CharField(max_length = 16, blank = True, null = True),
        ),

        migrations.RunPython(up, migrations.RunPython.noop),

        migrations.AlterField(
            model_name='meal',
            name='stock_card_number',
            field=models.PositiveIntegerField(unique = True),
        ),

        migrations.AlterField(
            model_name='course',
            name='group',
            field=models.CharField(max_length = 16),
        ),
    ]
