# Generated by Django 2.0.4 on 2018-06-25 11:03

from django.db import connection
from django.db import migrations, models
from django.db.models.deletion import PROTECT

def get_default_canteen():
  with connection.cursor() as cursor:
    cursor.execute("SELECT id FROM canteens ORDER BY id LIMIT 1")
    row = cursor.fetchone()

    if row:
      return row[0]
    else:
      cursor.execute("INSERT INTO canteens (name) values ('Jídelna 1')")
      cursor.execute("SELECT id FROM canteens ORDER BY id LIMIT 1")
      row = cursor.fetchone()

      return row[0]

class Migration(migrations.Migration):
    dependencies = [
        ('alto_django_canteen', '0005_create_courses'),
    ]

    operations = [
        migrations.CreateModel(
            name='Canteen',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=32)),
            ],
            options={
                'db_table': 'canteens',
            },
        ),
        migrations.AddField(
            model_name='meal',
            name='canteen',
            field=models.ForeignKey(default=get_default_canteen, on_delete=PROTECT, related_name='meals', to='alto_django_canteen.Canteen'),
            preserve_default=False,
        ),
        migrations.AlterUniqueTogether(
            name='meal',
            unique_together={('canteen', 'date', 'course', 'number')},
        ),
    ]
