# Generated by Django 2.0.4 on 2018-04-27 13:34

from django.db import migrations, models
import django.db.models.deletion


def up(apps, schema_editor):
    Meal   = apps.get_model('alto_django_canteen', 'Meal')
    Course = apps.get_model('alto_django_canteen', 'Course')

    breakfast = Course(name = 'breakfast', display_name = 'Snídaně',
                       order_number = 1,   served_at = '08:00')
    lunch     = Course(name = 'lunch',     display_name = 'Oběd',
                       order_number = 2,   served_at = '12:00')
    dinner    = Course(name = 'dinner',    display_name = 'Večeře',
                       order_number = 3,   served_at = '18:00')

    Course.objects.bulk_create([breakfast, lunch, dinner])

    Meal.objects.filter(course_shortcut = 'b').update(course = breakfast)
    Meal.objects.filter(course_shortcut = 'l').update(course = lunch)
    Meal.objects.filter(course_shortcut = 'd').update(course = dinner)

def down(apps, schema_editor):
    Meal   = apps.get_model('alto_django_canteen', 'Meal')
    Course = apps.get_model('alto_django_canteen', 'Course')

    try:
      breakfast = Course.objects.get(name = 'breakfast')
      lunch     = Course.objects.get(name = 'lunch')
      dinner    = Course.objects.get(name = 'dinner')
    except Course.DoesNotExist as error:
      raise Exception("Can't migrate down - mandatory course not found")

    if Meal.objects.exclude(course__in = [breakfast, lunch, dinner]).exists():
      raise Exception("Can't migrate down - found meals with irreversible course")

    Meal.objects.filter(course = breakfast).update(course_shortcut = 'b')
    Meal.objects.filter(course = lunch    ).update(course_shortcut = 'l')
    Meal.objects.filter(course = dinner   ).update(course_shortcut = 'd')


class Migration(migrations.Migration):
    dependencies = [
        ('alto_django_canteen', '0004_add_protect_to_order_fkeys'),
    ]

    operations = [
        migrations.AlterUniqueTogether(
            name='meal',
            unique_together={},
        ),

        migrations.RenameField(
            model_name='meal',
            old_name='course',
            new_name='course_shortcut',
        ),

        migrations.CreateModel(
            name='Course',
            fields=[
                # ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=16, primary_key=True)),
                ('display_name', models.CharField(max_length=64)),
                ('order_number', models.PositiveSmallIntegerField(unique=True)),
                ('served_at', models.TimeField()),
            ],
            options={
                'db_table': 'courses',
            },
        ),

        migrations.AddField(
            model_name='meal',
            name='course',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='meals', to='alto_django_canteen.Course'),
        ),

        migrations.AlterField(
            model_name='meal',
            name='course_shortcut',
            field=models.CharField(blank=True, null=True, choices=[('b', 'breakfast'), ('l', 'lunch'), ('d', 'dinner')], max_length=3),
        ),

        migrations.RunPython(up, down),

        migrations.AlterField(
            model_name='meal',
            name='course',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='meals', to='alto_django_canteen.Course'),
        ),

        migrations.RemoveField(
            model_name='meal',
            name='course_shortcut',
        ),

        migrations.AlterUniqueTogether(
            name='meal',
            unique_together={('date', 'course', 'number')},
        ),
    ]
