# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['alto_django_kredit',
 'alto_django_kredit.management',
 'alto_django_kredit.management.commands',
 'alto_django_kredit.migrations',
 'alto_django_kredit.queries',
 'alto_django_kredit.tests',
 'alto_django_kredit.tests.factories',
 'alto_django_kredit.tests.pages',
 'alto_django_kredit.views']

package_data = \
{'': ['*'],
 'alto_django_kredit': ['locale/cs_CZ/LC_MESSAGES/*',
                        'static/kredit/*',
                        'templates/kredit/*']}

install_requires = \
['alto-django-sk>=0.1.1,<0.2.0',
 'alto-django-utils>=0.1,<0.2',
 'django-bootstrap3>=9.1.0,<12.2.0',
 'django>=2.0.3,<2.1',
 'djangorestframework>=3.7.7,<3.11',
 'dynamic-rest>=2.0,<2.1',
 'pydash>=4.5.0,<4.9',
 'rules>=1.3,<2.3']

extras_require = \
{'test': ['pyyaml>=3.12,<5.4',
          'splinter>=0.9.0,<0.14',
          'factory-boy>=2.12.0,<3.0.0',
          'psycopg2-binary>=2.8.3,<2.9',
          'pytest>=6.1,<7.0',
          'pytest-django>=4.1.0,<5.0.0',
          'pytest-cov>=2.10,<3.0',
          'alto-django-food[test]>=0.1,<0.2',
          'alto-django-mailing[test]>=0.1,<0.2',
          'alto-django-settings[test]>=0.1,<0.2',
          'alto-django-client-auth[test]>=0.1,<0.2'],
 'test-watch': ['pytest-watch>=4.2.0,<5.0.0', 'pytest-testmon>=1.0.3,<2.0.0']}

setup_kwargs = {
    'name': 'alto-django-kredit',
    'version': '0.1.2',
    'description': 'django kredit app',
    'long_description': '# alto-django-kredit\n',
    'author': 'Jakub Kaláb',
    'author_email': 'jakubkalab@gmail.com',
    'maintainer': 'Jakub Kaláb',
    'maintainer_email': 'jakubkalab@gmail.com',
    'url': 'http://gitlab.apps.asrv.cz/python/alto-django-kredit',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
