from django.conf.urls import url, include
from dynamic_rest.routers import DynamicRouter
from .views.generic  import (ClientViewSet, ClientInfoViewSet, TransactionViewSet,
                             HistoricTransactionViewSet)
from .views.transactions import CreateTransaction, GetTransactions, GetTransactionKinds
from .views.balances import GetBalances, ShowBalance
from .views.clients_with_transaction_sums import ClientsWithTransactionSums

crud_router = DynamicRouter()

crud_router.register_resource(ClientViewSet)
crud_router.register_resource(ClientInfoViewSet)
crud_router.register_resource(TransactionViewSet)
crud_router.register_resource(HistoricTransactionViewSet)

app_name    = 'alto_django_kredit'
urlpatterns = [
  url(r'^crud/', include(crud_router.urls)),
  url(r'^show_balance$',          ShowBalance.as_view(),         name = 'show-balance'),
  url(r'^get_balances$',          GetBalances.as_view(),         name = 'get-balances'),
  url(r'^get_transactions$',      GetTransactions.as_view(),     name = 'get-transactions'),
  url(r'^get_transaction_kinds$', GetTransactionKinds.as_view(), name = 'get-transaction-kinds'),
  url(r'^create_transaction$',    CreateTransaction.as_view(),   name = 'create-transaction'),
  url(r'^clients/with_transaction_sums$', ClientsWithTransactionSums.as_view(),
      name = 'clients-with-transaction-sums'),
]
