from alto_django_kredit.models import Client
from alto_django_kredit.queries.client_finder import ClientFinder

class AmbiguousClientFinder(ClientFinder):
  def clients_for_card(self, card_number):
    if len(card_number) == 6:
      return Client.objects.filter(card_id = card_number)
    elif len(card_number) < 6:
      return Client.objects.filter(card_id__contains = card_number)
    else:
      raise self.InvalidCardNumber()

  def is_valid_card_number(self, card_number):
    return len(card_number) <= 6
