from rules import predicate, add_perm, is_staff, is_superuser

@predicate
def owns_client(user, client):
  return client and hasattr(user, 'client') and user.client == client

add_perm('alto_django_kredit.add_client',    is_superuser | is_staff)
add_perm('alto_django_kredit.view_client',   is_superuser | is_staff | owns_client)
add_perm('alto_django_kredit.change_client', is_superuser | is_staff | owns_client)
add_perm('alto_django_kredit.delete_client', is_superuser | is_staff | owns_client)
