# Generated by Django 2.0.13 on 2021-04-05 11:21

from django.db import migrations, models

def normalize_client_statuses(apps, _schema_editor):
  Client = apps.get_model('alto_django_kredit', 'Client')

  Client.objects.filter(status__iregex = r'^[1y]$').update(status = 'A')
  Client.objects.filter(status__iregex = r'^0?$'  ).update(status = 'N')

class Migration(migrations.Migration):
    dependencies = [
        ('alto_django_kredit', '0018_create_model_for_kredit_permissions'),
    ]

    operations = [
        migrations.RunPython(normalize_client_statuses, migrations.RunPython.noop),
        migrations.AlterField(
            model_name='client',
            name='status',
            field=models.CharField(choices=[('A', 'active'), ('N', 'inactive'), ('U', 'unassigned')], default='A', max_length=1, verbose_name='Status'),
        ),
    ]
