# Generated by Django 2.0.8 on 2018-10-09 12:52

from django.db import migrations

class Migration(migrations.Migration):
  dependencies = [
    ('alto_django_kredit', '0014_transaction_bill_header'),
  ]

  operations = [
    migrations.RunSQL('create type transaction_values as (amount decimal, balance decimal)',
                      'drop type transaction_values'),

    migrations.RunSQL(
      '''
      create function compute_transaction_values(agg_values transaction_values,
                                                 cur_amount  decimal,
                                                 cur_balance decimal,
                                                 is_settlement boolean)
      returns transaction_values
      immutable
      language plpgsql
      as $$ begin
        if is_settlement
        then return (cur_balance - agg_values.balance, cur_balance);
        else return (cur_amount,                       agg_values.balance + cur_amount);
        end if;
      end $$
      ''',
      'drop function compute_transaction_values'),

    migrations.RunSQL(
      '''
      create aggregate transaction_agg(decimal, decimal, boolean) (
        sfunc = compute_transaction_values,
        stype = transaction_values,
        initcond = '(0, 0)'
      )
      ''',
      'drop aggregate transaction_agg(decimal, decimal, boolean)')
  ]
