from django.test import TestCase
from django.contrib.auth import get_user_model
from alto_django_kredit.models import Client
from alto_django_kredit.tests.factories.client import ClientFactory

User = get_user_model()

class DeleteUserWithClientTests(TestCase):
  def test_deletes_user_with_client(self):
    client = ClientFactory.create()
    user   = User.objects.create_user('user', 'user@test.cz', 'user', client = client)

    client.delete()

    with self.assertRaises(User.DoesNotExist):
      user.refresh_from_db()

  def test_doesnt_delete_client_with_user(self):
    client = ClientFactory.create()
    user   = User.objects.create_user('user', 'user@test.cz', 'user', client = client)

    user.delete()

    # should not raise error
    client.refresh_from_db()
