from django.contrib.auth import get_user_model
from rest_framework.test import APITestCase
from alto_django_kredit.models import ClientInfo
from alto_django_kredit.tests.factories.client import ClientFactory
from alto_django_client_auth.tests.helpers import ClientAuthHelpers

User = get_user_model()

class ClientUserDeletionTests(APITestCase, ClientAuthHelpers):
  def setUp(self):
    self.clnt = ClientFactory.create()

    User.objects.create_user('user',  'user@test.cz',  'user', client = self.clnt)
    User.objects.create_user('admin', 'admin@test.cz', 'admin', is_superuser = True)

  def test_with_info(self):
    ClientInfo.objects.create(client = self.clnt, typ = 'A')

    token    = self.get_token(username = 'user', password = 'user').data['token']
    response = self.set_client_type('B', token)

    self.clnt.info.refresh_from_db()

    self.assertEqual(response.status_code, 204)
    self.assertEqual(self.clnt.info.typ, 'B')

  def test_with_no_info(self):
    token    = self.get_token(username = 'user', password = 'user').data['token']
    response = self.set_client_type('B', token)

    self.assertEqual(response.status_code, 400)
    self.assertEqual(response.data['detail'], 'Klient nemá info záznam.')

  def test_with_no_client(self):
    token    = self.get_token(username = 'admin', password = 'admin').data['token']
    response = self.set_client_type('B', token)

    self.assertEqual(response.status_code, 404)
    self.assertEqual(response.data['detail'], 'Uživatel admin není asociován s žádným klientem.')
