from django.urls import reverse
from django.contrib.auth import get_user_model
from rest_framework.test import APITestCase
from alto_django_settings.models import Setting
from alto_django_kredit.models import Client
from alto_django_kredit.tests.factories.client import ClientFactory

User = get_user_model()

class TestGetClientsForSelect(APITestCase):
  def test_with_enabled_select(self):
    Setting.objects.create(key   = 'auth.login.client_select',
                           value = { 'must_authenticate': False })

    client1 = ClientFactory.create(client_id = '123', card_id = '123',
                                   firstname = 'Testy', surname = 'Testson')
    client2 = ClientFactory.create(client_id = '234', card_id = '234',
                                   firstname = 'Tomáš', surname = 'Marný')
    client3 = ClientFactory.create(client_id = '345', card_id = '345',
                                   firstname = 'Prokop', surname = 'Buben')
    client3 = ClientFactory.create(client_id = '456', card_id = '456',
                                   firstname = 'Jan', surname = 'Novák')

    user1 = User.objects.create(client = client1, username = 'testy')
    user2 = User.objects.create(client = client2, username = 'tomas')
    user3 = User.objects.create(client = client3, username = 'prokop', is_active = False)

    response = self.client.get(reverse('alto_django_client_auth:get-clients-for-select'))

    assert response.status_code   == 200
    assert response.data['count'] == 2
    assert response.data['results']['clients'][0]['client_id'] == '234'
    assert response.data['results']['clients'][1]['client_id'] == '123'
    assert list(response.data['results']['clients'][0].keys()) == \
      ['id', 'client_id', 'card_id', 'firstname', 'surname']

  def test_with_disabled_select(self):
    response = self.client.get(reverse('alto_django_client_auth:get-clients-for-select'))

    assert response.status_code    == 403
    assert response.data['detail'] == 'Nebyly zadány přihlašovací údaje.'
