from dynamic_rest.serializers import DynamicRelationField
from alto_django_utils.serializers import serializer_for
from alto_django_base_auth.serializers import UserSerializer as BaseUserSerializer
from alto_django_kredit.models import Client
from .models import User

class UserSerializer(BaseUserSerializer):
  class Meta(BaseUserSerializer.Meta):
    model  = User
    fields = BaseUserSerializer.Meta.fields + ['client', 'pin']

  client = DynamicRelationField('alto_django_kredit.serializers.ClientSerializer')

ClientSerializerForSelect = \
  serializer_for(Client, ('id', 'client_id', 'card_id', 'firstname', 'surname'))
